# 2/7/2026 12:37pm
# This version is working but still showing inaccurate results
# AI was used to create this 

from machine import I2C, Pin
import utime
from time import sleep

from pimoroni import Button
from picographics import PicoGraphics, DISPLAY_PICO_DISPLAY, PEN_P4
from pimoroni import RGBLED

# We're only using a few colors so we can use a 4 bit/16 colour palette and save RAM!
display = PicoGraphics(display=DISPLAY_PICO_DISPLAY, pen_type=PEN_P4, rotate=180)
led = RGBLED(6, 7, 8)
display.set_backlight(0.85)
display.set_font("bitmap8")
button_a = Button(12)  # bottom right
button_b = Button(13)  # top Right
button_x = Button(14)  # bottom left
button_y = Button(15)  # top left
WHITE = display.create_pen(255, 255, 255)
BLACK = display.create_pen(0, 0, 0)
CYAN = display.create_pen(0, 255, 255)
MAGENTA = display.create_pen(255, 0, 255)
YELLOW = display.create_pen(255, 255, 0)
GREEN = display.create_pen(0, 255, 0)
RED = display.create_pen(255, 0, 0)


# HANDY FUNCTION TO CLEAR SCREEN
def clear():
    display.set_pen(BLACK)
    display.clear()
    display.update()

#DISPLAY WELCOME MSG
clear()                                          # clear to black
display.set_pen(CYAN)                            # change the pen colour

#display.text(text, x, y, wordwrap, scale, angle, spacing)
led.set_rgb(0, 0, 250)
display.text("HRM-2000", 5, 10, 240, 6)          # display some text on the screen
display.update()                                 # update the display
sleep(2)
clear()

Min_rate   = 80                         #Preset primary data
heart_rate = 81
Max_rate   = 82

def Update_Stat(Current_BPM):           #Update stats, based on current data
    global Min_rate
    global heart_rate
    global Max_rate
    heart_rate = round(Current_BPM)
    if Current_BPM < Min_rate: Min_rate = round(Current_BPM)
    if Current_BPM > Max_rate: Max_rate = round(Current_BPM)   

def Update_Stat_Display():               #Update and draw the screen data
    clear()
    display.set_pen(CYAN)              
    Msg = "MIN " + str(Min_rate)
    display.text(Msg, 2, 5, 240, 4)
    display.set_pen(YELLOW)            
    Msg = "NOW " + str(heart_rate)
    display.text(Msg, 2, 55, 240, 4)  
    display.set_pen(RED)              
    Msg = "Max " + str(Max_rate)
    display.text(Msg, 2, 100, 240, 4)
    display.update()
     
Update_Stat_Display()


# 1. High-Speed I2C (Pins 4/5)
i2c = I2C(0, sda=Pin(4), scl=Pin(5), freq=400000)
ADDR = 0x57

def write_reg(reg, val):                           #Function to write data to sensor
    i2c.writeto_mem(ADDR, reg, bytes([val]))

# 2. Setup (Verified Working Settings)             #Set basic parameters
write_reg(0x09, 0x40) # Reset
utime.sleep_ms(100)
write_reg(0x09, 0x02) # Red Only
write_reg(0x0C, 0x1F) # Verified Power Level
write_reg(0x08, 0x00) # No averaging

# 3. Smoothing Variables                           # The sensor data needs smoothing/averaging
beats = 0
start_time = utime.ticks_ms()
crossed_threshold = False
history = [] 
bpm_history = [] # For averaging the final result
print("System Stabilized. Reading Heart Rate...")

while True:
    try:
        # Clear pointers for fresh data
        i2c.writeto_mem(ADDR, 0x04, b'\x00\x00\x00') 
        utime.sleep_ms(5) 
        # Read 3 bytes
        d = i2c.readfrom_mem(ADDR, 0x07, 3)
        red_val = (d[0] << 16 | d[1] << 8 | d[2]) & 0x3FFFF
        if red_val > 10000:
            # Signal History for trigger
            history.append(red_val)
            if len(history) > 15: history.pop(0)
            avg_val = sum(history) / len(history)
            # TRIGGER (Auto-sensing)
            if red_val > (avg_val + 1) and not crossed_threshold:
                beats += 1
                crossed_threshold = True
                print("❤️", end="")
            elif red_val < avg_val: 
                crossed_threshold = False
            # Calculate BPM every 10 seconds for higher resolution
            now = utime.ticks_ms()
            elapsed = utime.ticks_diff(now, start_time)
            if elapsed >= 10000:                                #ten seconds
                raw_bpm = (beats / (elapsed / 1000.0)) * 60
                # Smooth the BPM display using a small moving average
                bpm_history.append(raw_bpm)
                if len(bpm_history) > 5: bpm_history.pop(0)
                smooth_bpm = sum(bpm_history) / len(bpm_history)
                print(f" -> HEART RATE: {smooth_bpm:.1f} BPM")
                beats = 0
                start_time = now
                # Test the data, set RGB LED to RED if poor data 
                if red_val < 40000:
                    print(" -> POOR SIGNAL: Check Sensor Placement")
                    led.set_rgb(250, 0, 0)                           
                else:
                    # (Your existing BPM calculation logic)
                    print(f" -> HEART RATE: {smooth_bpm:.1f} BPM")
                    print(round(smooth_bpm))
                    Update_Stat(smooth_bpm)
                    Update_Stat_Display()  
                    with open("HR.csv", "a") as file:          #Write data into CSV file for easy analysis
                        D_Val = str(round(smooth_bpm)) + ","
                        file.write(str(D_Val))
                        file.close()
                        led.set_rgb(0, 155, 0)                 #Set RGB LED to green showing good readings
        else:
            history = []
            utime.sleep_ms(200) 
            
    except Exception:
        utime.sleep_ms(10)
